#include "usbadc10.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#define N 100000

void PrintDeviceInfo(device_t Device)
{
    result_t Result;
    printf("Read device information... ");

    usbadc10_get_identity_information_t DeviceInfo;
    Result = usbadc10_get_identity_information(Device, &DeviceInfo);

    printf("Done\n");

    printf("  -- Device information --\n");
    printf("  Product: %s %s\n", DeviceInfo.Manufacturer, DeviceInfo.ProductName);
    printf("  Hardware version: %d.%d.%d\n", DeviceInfo.HardwareMajor, DeviceInfo.HardwareMinor, DeviceInfo.HardwareBugfix);
    printf("  Serial number: %d\n", DeviceInfo.SerialNumber);
    printf("  Firmware version: %d.%d.%d\n", DeviceInfo.FirmwareMajor, DeviceInfo.FirmwareMinor, DeviceInfo.FirmwareBugfix);
}

int main()
{
    device_t device = usbadc10_open_device("com:///dev/ttyACM0");
    PrintDeviceInfo(device);
    usbadc10_get_conversion_t data;
    usbadc10_get_conversion(device, &data);
    for(int j=0; j<10; j++)
        printf("%i ", data.data[j]);
    printf("\n");
    usbadc10_close_device(&device);
}
